﻿var rowNum;
var identifyData;
var DVB = 0;
var ATSC = 1;
var CUSTOM = 17;
var CUR_PID = 2;
var COL_NUM = 4;

var rowIdArray = ["srcPort", "srcPid", "curPid", "pidType"];
var dvbIdArray = ["dvbServiceId", "dvbServiceName", "serviceProvider", "charCode", "dvbServiceType", "customType", "runStatus", "encryptStatus", "scheduleFlag", "followFlag"];
var DVB_NUM = 10;
var atscIdArray = ["atscServiceId", "atscServiceName", "majorChannel", "minorChannel", "channelTsid", "atscServiceType", "modulMode", "serviceSource"];
var ATSC_NUM = 8;
var curPid = [];
var id;

window.onresize = function()
{
	$("#mainContent").css("height", function(index, value)
	{
		return ((parent.rightIframeHeight - 30) + "px");
	});
}

$(document).ready(function()
{
	var args = GetArgs();
	id = args["ID"];
	
	group = args["group"];
	userName = args["userName"];
	mainIpAddr = args["mainIpAddr"];
	var breadCrumbText = encodeURIComponent("详细", "utf-8");
	$("#transferFrame").attr("src", "http://" + mainIpAddr + "/asp/transfer.asp?group=" + group + "&userName=" + userName +"&information=" + breadCrumbText);
	$("#mainContent").css("height", function(index, value)
	{
		return ((parent.rightIframeHeight - 30) + "px");
	});
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
		
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam()
{
	var data;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();
	var infoData;

	xmlHttp.open("GET", "/goform/formIPQAM?type=" + PROGRAM_DETAIL + "&cmd=" + GET + "&id=" + id + "&language=" + language 
		+ "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				length = data.length;
				identifyData = parseInt(data[length - 1], 10);
				if(length < 2)
				{
					return;
				}
				rowNum = length - 2;
				DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
				if(rowNum != 0)
				{
					updateTableData(data);
				}
				infoData = data[length - 2].split(SECOND_DELIMITER);
				if(identifyData == DVB)
				{
					$("#dvbInfo").css("display", "");
					$("#atscInfo").css("display", "none");
					for(var i = 0; i < DVB_NUM; i++)
					{
						$("#" + dvbIdArray[i]).val(infoData[i]);
					}
					changeServiceType($("#dvbServiceType"));
				}
				else
				{
					$("#dvbInfo").css("display", "none");
					$("#atscInfo").css("display", "");
					for(var i = 0; i < ATSC_NUM; i++)
					{
						$("#" + atscIdArray[i]).val(infoData[i]);
					}
				}
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function updateTableData(data)
{
	var rowData;
	var index;
	
	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		rowData = data[i].split(SECOND_DELIMITER);
		for(var j = 0; j < COL_NUM; j++)
		{
			if(j == CUR_PID)
			{
				$("#" + rowIdArray[j] + index).val(rowData[j]);
				curPid.push(parseInt(rowData[j]));
			}
			else
			{
				$("#" + rowIdArray[j] + index).html(rowData[j]);
			}
		}
	}
}

function changeServiceType(obj)
{
	if(parseInt(obj.val(), 10) == CUSTOM)
	{			
		$("#customTypeTr").css("display", "");
	}
	else
	{
		$("#customTypeTr").css("display", "none");
	}
}

function checkPidValue(obj)
{
    var pos = parseInt(obj.attr("id").slice(6), 10) - 1;
	for(var i = 0; i < rowNum; i++)
    {
        if(i == pos)
        {
            continue;
        }
        else
        {
			if(parseInt($("#curPid" + (i + 1)).val()) == curPid[pos])
            {
                $("#curPid" + (i + 1)).val() = obj.val();
            }
        }
    }
}

function changeServiceId()
{
	parent.serviceIdChange = true;
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PROGRAM_DETAIL + "&cmd=" + SET + "&id=" + id + "&language=" + language + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formIPQAM", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
				if(language == ENGLISH)
				{
					alert("Set Successfully!");
				}
				else
				{
					alert("设置成功！");
				}
				if(parent.serviceIdChange == true)
				{
					if(identifyData == DVB)
					{
						parent.muxServiceId = $("#dvbServiceId").val();
					}
					else if(identifyData == ATSC)
					{
						parent.muxServiceId = $("#atscServiceId").val();
					}
					parent.displayParam();
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	var index;
	var rowData;
	var infoData;
	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		if(i == 0)
		{
			rowData = $("#curPid" + index).val();
		}
		else
		{
			rowData += SECOND_DELIMITER + $("#curPid" + index).val();
		}
	}
	if(identifyData == DVB)
	{
		for(var i = 0; i < DVB_NUM; i++)
		{
			if(i == 0)
			{
				infoData = $("#" + dvbIdArray[i]).val();
			}
			else if((i == 1) || (i == 2))
			{
				infoData += SECOND_DELIMITER + $("#" + dvbIdArray[i]).val().replace(/\+/g, "%2B").replace(/\&/g, "%26");
			}
			else
			{
				infoData += SECOND_DELIMITER + $("#" + dvbIdArray[i]).val();
			}
		}
	}
	else
	{
		for(var i = 0; i < ATSC_NUM; i++)
		{
			if(i == 0)
			{
				infoData = $("#" + atscIdArray[i]).val();
			}
			else
			{
				infoData += SECOND_DELIMITER + $("#" + atscIdArray[i]).val();
			}
		}
	}
	
	data = rowData + FIRST_DELIMITER + infoData;
	return data;
}

function paramCheck()
{
 	var returnFlag;
	var char;
	for(var i = 0; i < rowNum; i++)
	{
		returnFlag = ValidateParam($("#curPid" + (i + 1)), "INT_DEC_HEX", 32, 8191, "<Current PID>", "<当前PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	if(identifyData == DVB)
	{
		returnFlag = ValidateParam($("#" + dvbIdArray[0]), "INT_DEC_HEX", 1, 65535, "<Service ID>", "<节目号>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + dvbIdArray[1]), "LENGTH", 0, 31, "<Service Name>", "<节目名称>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateName($("#" + dvbIdArray[1]), language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + dvbIdArray[2]), "LENGTH", 0, 31, "<Service Provider>", "<节目提供商>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateName($("#" + dvbIdArray[2]), language);
		if(returnFlag == false)
		{
			return false;
		}
		if($("#" + dvbIdArray[5]).prop("disabled") == false)
		{
			returnFlag = ValidateParam($("#" + dvbIdArray[5]), "INT_DEC", 17, 255, "<Custom Type>", "<自定义节目类型>", language);
			if(returnFlag == false)
			{
				return false;
			}		
		}
	}
	else
	{
		returnFlag = ValidateParam($("#" + atscIdArray[0]), "INT_DEC_HEX", 1, 65535, "<Service ID>", "<节目号>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + atscIdArray[1]), "LENGTH", 0, 31, "<Service Name>", "<节目名称>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateName($("#" + atscIdArray[1]), language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + atscIdArray[2]), "INT_DEC", 1, 99, "<Major Channel>", "<主频道号>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + atscIdArray[3]), "INT_DEC", 0, 999, "<Minor Channel>", "<子频道号>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + atscIdArray[4]), "INT_DEC", 0, 65535, "<Channel TSID>", "<频道流ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + atscIdArray[7]), "INT_DEC", 1, 4095, "<Service Source>", "<节目源>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;
}
